package com.twentyfouri.tvlauncher.adapters

import android.annotation.SuppressLint
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.ListAdapter
import androidx.recyclerview.widget.RecyclerView
import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.data.ColumnItem
import com.twentyfouri.tvlauncher.data.ColumnItemType
import com.twentyfouri.tvlauncher.widgets.RecordingItemView
import com.twentyfouri.tvlauncher.widgets.SettingsItemView

class ColumnItemAdapter: ListAdapter<ColumnItem, ColumnItemAdapter.ColumnItemViewHolder>(ColumnItemDiffCallback()) {

    override fun getItemViewType(position: Int): Int {
        return getItem(position).type.ordinal
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ColumnItemViewHolder {
        val view = LayoutInflater.from(parent.context).inflate(
            getLayoutId(viewType),
            parent,
            false)
        return ColumnItemViewHolder(view)
    }

    private fun getLayoutId(viewType: Int) = when(viewType) {
        ColumnItemType.LABEL.ordinal -> R.layout.recording_settings_item_for_viewholder
        else -> R.layout.recording_item_for_viewholder
    }

    override fun onBindViewHolder(holder: ColumnItemViewHolder, position: Int) {
        when(getItemViewType(position)) {
            ColumnItemType.LABEL.ordinal -> (holder.itemView as? SettingsItemView)?.apply { bindLabel(getItem(position).text ?: "") }
            else -> (holder.itemView as? RecordingItemView)?.apply { bind(getItem(position)) }
        }
    }

    class ColumnItemViewHolder(
        itemView: View
    ) : RecyclerView.ViewHolder(itemView)

    class ColumnItemDiffCallback : DiffUtil.ItemCallback<ColumnItem>() {

        override fun areItemsTheSame(
            oldItem: ColumnItem,
            newItem: ColumnItem
        ): Boolean {
            return oldItem == newItem
        }

        @SuppressLint("DiffUtilEquals")
        override fun areContentsTheSame(
            oldItem: ColumnItem,
            newItem: ColumnItem
        ): Boolean {
            return oldItem == newItem
        }
    }
}