package com.twentyfouri.tvlauncher

import com.twentyfouri.smartmodel.phoenix.PhoenixAnalyticsListener
import com.twentyfouri.smartmodel.phoenix.PhoenixApiEvents
import com.twentyfouri.smartmodel.phoenix.model.user.PhoenixLoginCredentialsPin
import com.twentyfouri.tvlauncher.common.analytics.AnalyticsConstants
import com.twentyfouri.tvlauncher.common.analytics.AnalyticsEvent
import com.twentyfouri.tvlauncher.common.analytics.YouboraAnalytics

class EntelApiAnalyticsListener(val youboraAnalytics: YouboraAnalytics) : PhoenixAnalyticsListener {
    override fun onRestoreSession(event: PhoenixApiEvents.PhoenixRestoreSessionEvent) {
        when (event.credentials) {
            is PhoenixLoginCredentialsPin -> {
                youboraAnalytics.reportApiEvent(AnalyticsEvent(AnalyticsConstants.LOGIN_WITH_PIN))
            }
        }
    }
    override fun onCallFailed(event: PhoenixApiEvents.PhoenixCallFailedEvent) {
        youboraAnalytics.reportApiException(e = event.e, urlPath = event.urlPath)
    }
}