package com.twentyfouri.tvlauncher

import androidx.test.platform.app.InstrumentationRegistry
import androidx.test.ext.junit.runners.AndroidJUnit4
import com.twentyfouri.tvlauncher.data.AppListDao
import com.twentyfouri.tvlauncher.data.AppUsageDatabase
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.runBlocking
import org.junit.Assert.assertNotEquals
import org.junit.Assert.assertNotNull
import org.junit.Before
import org.junit.Test
import org.junit.runner.RunWith

/**
 * Instrumented test, which will execute on an Android device.
 *
 * @see [Testing documentation](http://d.android.com/tools/testing)
 */
@RunWith(AndroidJUnit4::class)
class AppListDaoTest {

    private lateinit var appListDao : AppListDao

    @Before
    fun init() {
        appListDao =
            AppListDao(
                InstrumentationRegistry.getInstrumentation().targetContext,
                AppUsageDatabase.getInstance(InstrumentationRegistry.getInstrumentation().targetContext)
            )
    }

    @Test
    fun loadApps(): Unit = runBlocking {
        val authenticateJob = CoroutineScope(Dispatchers.IO).launch {
            val apps = appListDao.getAppList()
            assertNotEquals(0, apps.size)
        }
        authenticateJob.join()
    }

    @Test
    fun loadGames(): Unit = runBlocking {
        val authenticateJob = CoroutineScope(Dispatchers.IO).launch {
            val apps = appListDao.getGameList()
            assertNotNull(apps)
        }
        authenticateJob.join()
    }

    @Test
    fun loadSettings(): Unit = runBlocking {
        val authenticateJob = CoroutineScope(Dispatchers.IO).launch {
            val apps = appListDao.getSettingsList(null)
            assertNotEquals(0, apps.size)
        }
        authenticateJob.join()
    }
}